/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.core.impl.integration.sync;

import com.day.cq.contentsync.handler.util.RequestResponseFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.engine.SlingRequestProcessor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={SyncTranslationInvoker.class})
public class SyncTranslationInvoker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncTranslationInvoker.class);
    @Reference
    private RequestResponseFactory requestResponseFactory;
    @Reference
    private SlingRequestProcessor slingRequestProcessor;

    public void syncTranslationJobByPath(ResourceResolver resourceResolver, final String translationJobPath) {
        try {
            ByteArrayOutputStream renderStream = new ByteArrayOutputStream();
            HttpServletRequest renderRequest = this.requestResponseFactory.createRequest("POST", translationJobPath, (Map)new HashMap<String, Object>(){
                {
                    this.put(":operation", "GET_LATEST_STATUS");
                    this.put(":translationJobPath", translationJobPath);
                }
            });
            HttpServletResponse renderResponse = this.requestResponseFactory.createResponse((OutputStream)renderStream);
            this.slingRequestProcessor.processRequest(renderRequest, renderResponse, resourceResolver);
            renderResponse.flushBuffer();
        }
        catch (Exception e) {
            LOGGER.error("Failed to proceed with translation job path=\"{}\".", (Object)translationJobPath, (Object)e);
        }
    }
}

