/*
 * Decompiled with CFR 0.152.
 */
package com.smartling.aem.connector.context.impl.connection;

import com.smartling.aem.connector.context.ContextConnection;
import com.smartling.aem.connector.context.impl.connection.ClientProducer;
import com.smartling.aem.connector.context.impl.connection.ResourceLoadingHandler;
import com.smartling.cms.gateway.client.CmsGatewayClient;
import com.smartling.cms.gateway.client.CmsGatewayClientException;
import com.smartling.cms.gateway.client.command.CommandChannelHandler;
import com.smartling.cms.gateway.client.command.GetHtmlCommand;
import com.smartling.cms.gateway.client.command.GetResourceCommand;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContextGatewayConnection
implements ContextConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextGatewayConnection.class);
    private final ClientProducer clientProducer;
    private final ResourceLoadingHandler loadingHandler;
    private final AtomicReference<CmsGatewayClient> clientHolder = new AtomicReference();

    ContextGatewayConnection(ClientProducer clientProducer, ResourceLoadingHandler loadingHandler) {
        this.clientProducer = Objects.requireNonNull(clientProducer);
        this.loadingHandler = Objects.requireNonNull(loadingHandler);
    }

    @Override
    public void connect() throws CmsGatewayClientException {
        CmsGatewayClient client = this.clientProducer.create();
        boolean notConnected = this.clientHolder.compareAndSet(null, client);
        if (notConnected) {
            LOGGER.info("Connecting to the command channel for projectId=\"{}\". May take some time.", (Object)this.clientProducer.getProjectId());
            try {
                this.clientHolder.get().connect((CommandChannelHandler)new CommandChannelHandlerImpl(client));
            }
            catch (CmsGatewayClientException e) {
                this.clientHolder.compareAndSet(client, null);
                throw e;
            }
        } else {
            LOGGER.info("No need to reconnect for projectId=\"{}\": already connected.", (Object)this.clientProducer.getProjectId());
        }
    }

    @Override
    public void disconnect() throws IOException {
        CmsGatewayClient cmsGatewayClient = this.clientHolder.get();
        if (cmsGatewayClient != null) {
            LOGGER.info("Closing the command channel for projectId=\"{}\".", (Object)this.clientProducer.getProjectId());
            cmsGatewayClient.close();
        } else {
            LOGGER.warn("Attempt to disconnect from already closed channel for projectId=\"{}\".", (Object)this.clientProducer.getProjectId());
        }
    }

    @Override
    public String getProjectId() {
        return this.clientProducer.getProjectId();
    }

    private class CommandChannelHandlerImpl
    implements CommandChannelHandler {
        private final CmsGatewayClient client;

        CommandChannelHandlerImpl(CmsGatewayClient client) {
            this.client = client;
        }

        public void onConnect() {
            LOGGER.info("Connected to the command channel for projectId=\"{}\":", (Object)ContextGatewayConnection.this.clientProducer.getProjectId());
        }

        public void onDisconnect() {
            LOGGER.info("Disconnected from the command channel for projectId=\"{}\":", (Object)ContextGatewayConnection.this.clientProducer.getProjectId());
            ContextGatewayConnection.this.clientHolder.compareAndSet(this.client, null);
            try {
                this.client.close();
            }
            catch (IOException e) {
                LOGGER.error("Error on closing HTTP Async client for projectId=\"{}\":", (Object)ContextGatewayConnection.this.clientProducer.getProjectId(), (Object)e);
            }
        }

        public void onError(Throwable throwable) {
            LOGGER.error("Error during communication over command channel for projectId=\"{}\":", (Object)ContextGatewayConnection.this.clientProducer.getProjectId(), (Object)throwable);
            ContextGatewayConnection.this.clientHolder.compareAndSet(this.client, null);
            try {
                this.client.close();
            }
            catch (IOException e) {
                LOGGER.error("Error on closing HTTP Async client for projectId=\"{}\" after communication error:", (Object)ContextGatewayConnection.this.clientProducer.getProjectId(), (Object)e);
            }
        }

        public void onGetHtmlCommand(GetHtmlCommand command) {
            ContextGatewayConnection.this.loadingHandler.loadHtml(this.client, command);
        }

        public void onGetResourceCommand(GetResourceCommand command) {
            ContextGatewayConnection.this.loadingHandler.loadResource(this.client, command);
        }
    }
}

