;(function (document, $) {
    $(document).ready(function() {
        window.smartling.touchui.jobDialog.initializeForm('/services/smartling/job/workflows/asset');
    });
    var SMARTLING_JOB_DIALOG = "#smartling-job-dialog";
    var CORAL_ICON = SMARTLING_JOB_DIALOG + ' coral-icon[name="config-warn-element"]';
    var CORAL_ICON_TOOLTIP = SMARTLING_JOB_DIALOG + ' coral-tooltip[name="config-warn-element-tooltip"]'

    $(window).adaptTo("foundation-registry").register("foundation.collection.action.action", {
        name: "smartling.content.fragment.translate",
        handler: function(name, el, config, collection, selections) {
            var url = selections.map(function(item) { return $(item).data("foundation-collection-item-id"); }).join(';');
            window.smartling.touchui.jobDialog.openDialog(url);
            window.smartling.touchui.jobDialog.processValidationError = function() {
                $(CORAL_ICON).hover(function() {
                	var tooltip = $(CORAL_ICON_TOOLTIP);
                	tooltip.addClass('is-open');
                	tooltip.show();
                }, function() {
                	var tooltip = $(CORAL_ICON_TOOLTIP);
                	tooltip.removeClass('is-open');
                	tooltip.hide();
                });
            }
        }
    });

    var SMARTLING_SUPPORTED_MIME_TYPES = [
        "image/jpeg",
        "image/jpg",
        "image/png",
        "image/gif",
        "image/bmp",
        "image/tiff",
        "image/vnd.adobe.photoshop",
        "application/x-photoshop",
        "application/photoshop",
        "application/psd",
        "image/psd",
        "text/html",
        "text/xml",
        "text/plain",
        "application/msword",
        "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
        "application/vnd.ms-excel",
        "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
        "application/vnd.openxmlformats-officedocument.presentationml.presentation"
    ];

    $(window).adaptTo("foundation-registry").register("foundation.collection.action.activecondition", {
        name: "smartling-translation-dam-check",
        handler: function(name, el, config, collection, selections) {
            selections.every(function(elem, index) {
                var mimeType = $(elem).find("div.foundation-collection-assets-meta").data("assetMimetype");
                var isContentFragment = $(elem).find("meta.foundation-collection-quickactions").data("foundationCollectionQuickactionsRel").includes("foundation-damadmin-fragmentprops-activator");
                return isContentFragment || SMARTLING_SUPPORTED_MIME_TYPES.some(function(elem) {
                    return mimeType && elem.toLowerCase() === mimeType.toLowerCase();
                });
            });
        }
    });

})(jQuery(document), Granite.$);