;(function (document, $, Coral) {

    window.smartling = window.smartling || {};
    window.smartling.touchui = window.smartling.touchui || {};
    window.smartling.touchui.jobDialog = window.smartling.touchui.jobDialog || {};
    window.smartling.touchui.jobDialog.subpagesApi = window.smartling.touchui.jobDialog.subpagesApi || {};
    var dialog = window.smartling.touchui.jobDialog;
    var subpagesApi = dialog.subpagesApi || {};

    function initializeControls() {

        subpagesApi.excludedPaths = [];

        subpagesApi.getSubNodesUrlPredicateParameter = function() {
            return '&predicate=hierarchy';
        }

        subpagesApi.init = function(dialog) {
            var button = $(dialog).find('a.smartling-touch-js-coral3-subpages-selector-button');
            button.hide();

            var isDeepCheckbox = $(dialog).find('coral-checkbox[name="isDeep"]')
            isDeepCheckbox.checked = false;
        }

        var subNodesUrl = '.ext.json?_dc=' + new Date().getTime() + '&_charset_=utf-8';

        var columnViewItemTpl = function(tmplObj) {
            return '<div data-item-name="' + tmplObj.name + '" data-leaf="' + tmplObj.leaf + '" data-parent-path="' + tmplObj.parentPath + '" data-item-path="' + tmplObj.parentPath + '/' + tmplObj.name + '" class="smartling-touch-js-coral3-subpages-js-columnview-item coral3-ColumnView-item ' + tmplObj.drillDownClass + ' ' + tmplObj.selectedClass + '" aria-selected="' + tmplObj.selected + '" icon="folder">' +
                '<coral-columnview-item-thumbnail class="smartling-touch-js-coral3-subpages-js-select-item"><coral-icon class="coral3-Icon coral3-Icon--sizeS coral3-Icon--folder" icon="folder" size="S" role="img" aria-label="folder"></coral-icon></coral-columnview-item-thumbnail>' +
                '<coral-columnview-item-content data-leaf="' + tmplObj.leaf + '" data-item-name="' + tmplObj.name + '" data-parent-path="' + tmplObj.parentPath + '" class="smartling-touch-js-coral3-subpages-columnview-item">' + tmplObj.text + '</coral-columnview-item-content>' +
                '</div>'
        };

        //ToDo it's hardcoded sub-items dialog footer. Need to refactor in future.
        var dialogFooter = '<coral-dialog-footer>' +
            '<button id="smartling-touch-js-coral3-subpages-bulk-cancel" is="coral-button" class="coral-Form-field" variant="quiet">Cancel</button>' +
            '<button id="smartling-touch-js-coral3-subpages-bulk-select" is="coral-button" class="coral-Form-field" variant="primary">Select</button>' +
            '</coral-dialog-footer>';

        var excludedPathTpl = function(tmplObj) {
            return '<input type="hidden" name="excludedPaths" value="' + tmplObj.path + '">'
        }

        var removeFromArr = function(arr, funcArr) {
            var iArr = 0;
            while(iArr < arr.length) {
                if (funcArr && funcArr(arr[iArr])) {
                    arr.splice(iArr, 1);
                } else {
                    iArr++;
                }
            }
        }

        Coral.register({
            name: 'SubpagesSelectorTouch',
            tagName: 'subpages-selector-touch',
            className: 'coral-Overlay coral-FieldOverlay coral-Form-fieldwrapper',

            _initialize() {
                var dialogId = this.dataset.dialogId;
                this.$dialog = $('#' + dialogId);
                this.$dialog.append(dialogFooter);
                this.$dialogContent = this.$dialog.find('.smartling-touch-js-coral3-subpages-content');
                this.$form = $(this).closest("form");
                this.depth = 2;
                var self = this;

                //Handle open next pages level
                this.$dialog.on("click", ".smartling-touch-js-coral3-subpages-js-columnview-item", function(event) {
                    var $parentColumn = $(event.target).closest('[data-column-depth]');
                    var currentItemPath = event.target.dataset.parentPath + '/' + event.target.dataset.itemName;

                    //Disable clicking by opened item
                    if (self.currentPath.startsWith(currentItemPath)) {
                        return;
                    }

                    var nextDepth = $parentColumn.data('column-depth') + 1;
                    //Cleaning previous opened columns if they are located under another path(e.g. were opened tabs /path/b/c and user is opening /path/a)
                    for ( var i = nextDepth; i <= self.depth; i++) {
                        if (!currentItemPath.startsWith(self.currentPath)) {
                            self.$dialogContent.find('[data-column-depth=' + i + ']').remove();
                        }
                    }
                    self.depth = nextDepth;
                    self.currentPath = currentItemPath;

                    //Load new column only if current item is not leaf(has children)
                    if (this.dataset.leaf == 'false') {
                        self.loadNewColumn($parentColumn.data('column-depth') + 1, currentItemPath);
                    }
                });

                //Handle select/deselect page
                this.$dialog.on("click", ".smartling-touch-js-coral3-subpages-js-select-item", function(event) {
                    event.stopPropagation();
                    var $dataItem = $(event.target).closest('[data-parent-path]');
                    $dataItem.toggleClass('is-selected');
                    if ($dataItem.hasClass('is-selected')) {
                        $dataItem.attr('aria-selected', true);
                        self.handleSelectItem($dataItem);
                    } else {
                        $dataItem.attr('aria-selected', false);
                        self.handleDeselectItem($dataItem);
                    }
                });

                this.$dialog.find('#smartling-touch-js-coral3-subpages-bulk-select').on('click', function() {
                    self.$form.find('[name=excludedPaths]').remove();

                    //Just append all excluded paths to submit form
                    subpagesApi.excludedPaths.forEach(function(item) {
                        self.$form.append(excludedPathTpl({path: item}));
                    });
                    self.$dialog.get(0).hide();
                });

                this.$dialog.find('#smartling-touch-js-coral3-subpages-bulk-cancel').on('click', function() {
                    self.$dialog.get(0).hide();
                });
            },

            events: {
                'click .smartling-touch-js-coral3-subpages-selector-button': '_openSelectDialog'
            },

            //Initial setup of select dialog
            _openSelectDialog(event) {
                this.currentPath = dialog.getPayload();

                //Fetch root parent path and name from path parameter
                var lastSlashIndex = this.currentPath.lastIndexOf('/');
                var currentParentPath = this.currentPath.substring(0, lastSlashIndex);
                var currentItemName = this.currentPath.substring(lastSlashIndex + 1, this.currentPath.legnth);
                
                this.$dialogContent.empty();
                //Collect excluded path from form
                subpagesApi.excludedPaths = [];
                this.$form.find('[name=excludedPaths]').each(function(i, item) {
                    subpagesApi.excludedPaths.push(item.value);
                });
                //Generate root as current opened page/item
                var root = columnViewItemTpl({
                    text: currentItemName,
                    parentPath: currentParentPath,
                    name: currentItemName,
                    drillDownClass: 'coral3-ColumnView-item--drilldown',
                    leaf: true,
                    selected: true,
                    selectedClass: 'is-selected'
                });
                this.$dialogContent.append(`

                      <coral-columnview-column data-column-depth="1">
                        <coral-columnview-column-content data-parent-path="${dialog.getPayload()}">

                        </coral-columnview-column-content>
                      </coral-columnview-column>

                `).find('coral-columnview-column-content').append(root);

                this.loadNewColumn(2, this.currentPath);
                this.$dialog.get(0).show();
            },

            /*Load new column of items
              parentPath - path of the parent item for which should be fetched children
              $column - table column, where children will be appended.
            */
            loadNextLevel(parentPath, $column) {
                $.ajax({
                    url: parentPath + subNodesUrl + subpagesApi.getSubNodesUrlPredicateParameter()
                }).done(function(data) {
                    var itemsHtml = data.map(function(item) {
                        var leaf = !!item.leaf;
                        var itemPath = parentPath + '/' + item.name;
                        //If parent is unselected, then new loaded children also unselected
                        var isSelected = subpagesApi.excludedPaths.filter(function(exludedPath) {
                                           return itemPath.startsWith(exludedPath);
                                       }).length == 0;
                        return columnViewItemTpl({
                            text: item.text,
                            parentPath: parentPath,
                            name: item.name,
                            drillDownClass: leaf ? '' : 'coral3-ColumnView-item--drilldown',
                            leaf: leaf,
                            selected: isSelected,
                            selectedClass: isSelected ? 'is-selected' : ''
                        })
                    }).join('');

                    $column.find('coral-columnview-column-content').append(itemsHtml);
                });
            },

            //Dynamically load new column - create column html element and call loadNextLevel function
            loadNewColumn(depth, parentPath) {
                var $column = this.$dialogContent.append(`

                      <coral-columnview-column data-column-depth="${depth}">
                        <coral-columnview-column-content data-parent-path="${parentPath}">

                        </coral-columnview-column-content>
                      </coral-columnview-column>

                `).find('coral-columnview-column[data-column-depth=' + depth + ']');
                this.loadNextLevel(parentPath, $column);
            },

            //Handle events of select item
            handleSelectItem($selectedItem) {
                var currentPath = $selectedItem.data('item-path');
                var self = this;

                //Remove from excluded paths children of selected item and mark them as selected
                removeFromArr(subpagesApi.excludedPaths, function(excludedPath) {
                    var isRemoved = currentPath.startsWith(excludedPath);
                    if (isRemoved && currentPath !== excludedPath) {
                        var $parentItem = self.$dialogContent.find("[data-item-path='" + excludedPath + "']");
                        $parentItem.attr('aria-selected', true);
                        $parentItem.toggleClass('is-selected');

                        self.$dialogContent.find("[data-parent-path='" + excludedPath + "'][aria-selected=false]").each(function(i, item) {
                            if (subpagesApi.excludedPaths.indexOf(item.dataset.itemPath) < 0) {
                                subpagesApi.excludedPaths.push(item.dataset.itemPath);
                            }
                        });
                    }
                    return isRemoved;
                });
                this.handleSelectChild($selectedItem.data('parent-path'));
                this.handleSelectParent($selectedItem.data('item-path'))
            },

             //Recursive select of all parents for selected item
             handleSelectChild(parentPath) {
                var self = this;
                self.$dialogContent.find("[data-item-path='" + parentPath + "']").each(function(i, item) {
                    var itemPath = item.dataset.itemPath;
                    removeFromArr(subpagesApi.excludedPaths, function(excludedPath) {
                        return itemPath === excludedPath;
                    });
                    item.classList.add("is-selected");
                    item.setAttribute('aria-selected', true);
                    self.handleSelectChild(item.dataset.parentPath);
                });

                //Add to exclude paths all childs of selected parent
                //E.g. /content/a was full unselected and contains children /content/a/b and /content/a/c
                //when user is selecting /content/a/c, when /content/a marks as selected and removing from excludedPath, but at the same time
                ///content/a/b should be added to excluded paths
                self.$dialogContent.find("[data-parent-path='" + parentPath + "'][aria-selected=false]").each(function(i, item) {
                    if (subpagesApi.excludedPaths.indexOf(item.dataset.itemPath) < 0) {
                        subpagesApi.excludedPaths.push(item.dataset.itemPath);
                    }
                });
            },

            //Select all opened children in case when selected unchecked parent item
            handleSelectParent(itemPath) {
                var self = this;
                self.$dialogContent.find("[data-parent-path='" + itemPath + "']").each(function(i, item) {
                    item.classList.add("is-selected");
                    item.setAttribute('aria-selected', true);
                    self.handleSelectParent(item.dataset.itemPath);
                });
            },

            //Handles deselect item
            handleDeselectItem($deselectedItem) {
                var itemPath = $deselectedItem.data('item-path');

                //If item not presented in exludePaths array, then add it
                if (subpagesApi.excludedPaths.indexOf(itemPath) < 0) {
                    subpagesApi.excludedPaths.push(itemPath);
                }
                this.handleDeselectChild(itemPath);
            },

            //Recursive deselect all children
            handleDeselectChild(parentPath) {
                var self = this;
                self.$dialogContent.find("[data-parent-path='" + parentPath + "']").each(function(i, item) {
                    var itemPath = item.dataset.itemPath;
                    removeFromArr(subpagesApi.excludedPaths, function(excludedPath) {
                        return itemPath === excludedPath;
                    });
                    item.classList.remove("is-selected");
                    item.setAttribute('aria-selected', false);
                    self.handleDeselectChild(itemPath);
                });
            }
        });
    }

    $(document).ready(initializeControls);

    function initializeSubpagesEventHandler() {
        $('coral-checkbox[name="isDeep"]').change(function () {
            var button = $(this).closest('subpages-selector-touch').find('a.smartling-touch-js-coral3-subpages-selector-button');
            if (this.checked) {
                button.show();
            } else {
                button.hide();
            }
        });
    }

    $(document).ready(initializeSubpagesEventHandler);

})(document, Granite.$, window.Coral);